//%attributes = {}
// Method: apr_ VAT_ARR_CREATE
// 2008.05.22-13:52:32 / Arto Kokkila
// © Copyright 2008 Manage Applications
// Purpose: 
// Creates two tables to be used in creating vat for all apr rows.
//   -One table for vat accounts 
//   -One for vat sums
// 
// ------------------------------------------------------------
C_POINTER:C301($1; $apr_pVatAccountArr; $2; $apr_pVatSumArr)
C_LONGINT:C283($3; $apr_lValueWithVat)
C_TEXT:C284($apr_tVAT_Account)
C_REAL:C285($apr_rCurrency_Sum; $apr_rVAT_Percentage; $apr_rVat)
C_LONGINT:C283($apr_lIndex; $k)

$apr_pVatAccountArr:=$1
$apr_pVatSumArr:=$2
$apr_lValueWithVat:=$3

_rec FIRST(apr_kTbl)
_long:=_sel RecsInSel(apr_kTbl)

For ($apr_lIndex; 1; _long)
	_sel RELATE_ONE(ac_kAccount_ID; apr_kAccount_id)
	
	$apr_tVAT_Account:=_fld ValueStr(ac_kVAT_Account)
	$apr_rCurrency_Sum:=_fld ValueReal(apr_kCurrency_Sum)
	$apr_rVAT_Percentage:=_fld ValueReal(ac_kVAT_Percentage)
	
	If (($apr_tVAT_Account#"") & ($apr_rCurrency_Sum#0))  //AK: 2010-01-06
		$k:=Find in array:C230($apr_pVatAccountArr->; $apr_tVAT_Account)
		If ($k=-1)
			INSERT IN ARRAY:C227($apr_pVatAccountArr->; 1)
			INSERT IN ARRAY:C227($apr_pVatSumArr->; 1)
			$apr_pVatAccountArr->{1}:=$apr_tVAT_Account
			$k:=1
		End if 
		
		// ak 2012-02-10
		If ($apr_lValueWithVat=kFalse)
			$apr_rVat:=$apr_rCurrency_Sum*$apr_rVAT_Percentage/100
		Else 
			$apr_rVat:=_real TaxRemove($apr_rCurrency_Sum; $apr_rVAT_Percentage)
			$apr_rVat:=$apr_rVat*$apr_rVAT_Percentage/100
		End if 
		$apr_pVatSumArr->{$k}:=$apr_pVatSumArr->{$k}+$apr_rVat
		//
		
	End if 
	_sel REC_NEXT(apr_kTbl)
End for 
